# 🤖 BRA Chatbot - Balochistan Revenue Authority AI Assistant

A comprehensive web-based chatbot designed to provide instant assistance with Balochistan Revenue Authority services, tax information, and procedures. Built with Flask backend and modern web technologies.

![BRA Chatbot](https://img.shields.io/badge/Status-Ready%20to%20Deploy-brightgreen)
![Python](https://img.shields.io/badge/Python-3.8+-blue)
![Flask](https://img.shields.io/badge/Flask-2.3+-red)
![License](https://img.shields.io/badge/License-MIT-yellow)

## 🌟 Features

### 🎯 Core Functionality
- **Intelligent FAQ System**: Comprehensive knowledge base with 15+ BRA-specific FAQs
- **Smart Pattern Matching**: Advanced regex-based query understanding
- **Context-Aware Responses**: Maintains conversation context for better user experience
- **Multi-language Support**: English and Urdu greetings and responses

### 💼 BRA-Specific Services
- **Tax Information**: Sales tax rates, procedures, and regulations
- **Registration Guidance**: Step-by-step registration procedures
- **Payment Instructions**: Online payment methods and procedures
- **Contact Information**: Complete BRA contact details and office hours
- **E-Services**: Information about all available online services

### 🎨 Modern UI/UX
- **Responsive Design**: Works perfectly on desktop, tablet, and mobile
- **Professional Styling**: BRA-branded color scheme and typography
- **Interactive Elements**: Quick topic buttons and smart suggestions
- **Real-time Chat**: Instant messaging with typing indicators
- **Accessibility**: WCAG compliant with keyboard navigation support

### 🚀 Technical Features
- **RESTful API**: Clean API endpoints for easy integration
- **Error Handling**: Comprehensive error handling and user feedback
- **Performance Optimized**: Fast response times and efficient caching
- **Scalable Architecture**: Easy to extend with new features

## 📋 Prerequisites

- Python 3.8 or higher
- pip (Python package installer)
- Modern web browser (Chrome, Firefox, Safari, Edge)

## 🛠️ Installation & Setup

### 1. Clone or Download
```bash
# If you have the files, navigate to the directory
cd /Users/sadaqath/Desktop/PYTHON
```

### 2. Install Dependencies
```bash
# Install required packages
pip install -r requirements.txt

# Or install individually
pip install Flask Flask-CORS
```

### 3. Run the Application
```bash
# Start the Flask server
python bra_chatbot.py
```

### 4. Access the Chatbot
Open your web browser and go to:
```
http://localhost:5000
```

## 📁 Project Structure

```
PYTHON/
├── bra_chatbot.py          # Main Flask application
├── requirements.txt        # Python dependencies
├── README.md              # This file
├── templates/
│   └── index.html         # Main HTML template
├── static/
│   ├── css/
│   │   └── style.css      # Comprehensive styling
│   └── js/
│       └── script.js      # Interactive functionality
└── [other practice files]
```

## 🔧 Configuration

### Environment Variables (Optional)
Create a `.env` file for configuration:
```env
FLASK_ENV=development
FLASK_DEBUG=True
SECRET_KEY=your-secret-key-here
```

### Customization Options
- **Brand Colors**: Modify CSS variables in `static/css/style.css`
- **FAQ Content**: Update the `faqs` array in `bra_chatbot.py`
- **Response Patterns**: Customize `response_patterns` in the knowledge base
- **Contact Information**: Update `bra_info` dictionary

## 🌐 API Endpoints

### Chat API
```http
POST /api/chat
Content-Type: application/json

{
    "message": "What is the sales tax rate?",
    "conversation_id": "optional_conversation_id"
}
```

**Response:**
```json
{
    "message": "Rate of Sales Tax on Services is 15% except telecommunication where it is 19.5%",
    "type": "faq",
    "confidence": "high",
    "timestamp": "2024-01-01T12:00:00",
    "status": "success"
}
```

### Get FAQs
```http
GET /api/faqs
```

### Get Contact Info
```http
GET /api/contact
```

## 💡 Usage Examples

### Basic Questions
- "What is sales tax rate?"
- "How to register for sales tax?"
- "What are your office hours?"
- "How can I contact BRA?"

### Complex Queries
- "I need help with online tax payment procedure"
- "What documents are required for registration?"
- "Can you explain the appeals process?"

### Quick Actions
Use the topic buttons for instant access to:
- Registration procedures
- Tax rates information
- Online payment methods
- Contact information

## 🎨 Customization Guide

### Adding New FAQs
1. Open `bra_chatbot.py`
2. Add new entries to the `faqs` array:
```python
{
    "question": "Your new question?",
    "answer": "Your detailed answer here.",
    "keywords": ["keyword1", "keyword2", "relevant", "terms"]
}
```

### Modifying Responses
Update the `response_patterns` in the `BRAKnowledgeBase` class:
```python
{
    "patterns": [r"your|regex|pattern"],
    "responses": ["Response 1", "Response 2", "Response 3"]
}
```

### Styling Changes
Modify CSS variables in `static/css/style.css`:
```css
:root {
    --primary-color: #your-color;
    --secondary-color: #your-color;
    --accent-color: #your-color;
}
```

## 🚀 Deployment Options

### Local Development
```bash
python bra_chatbot.py
```

### Production with Gunicorn
```bash
pip install gunicorn
gunicorn -w 4 -b 0.0.0.0:5000 bra_chatbot:app
```

### Docker Deployment
Create `Dockerfile`:
```dockerfile
FROM python:3.9-slim
WORKDIR /app
COPY requirements.txt .
RUN pip install -r requirements.txt
COPY . .
EXPOSE 5000
CMD ["gunicorn", "-w", "4", "-b", "0.0.0.0:5000", "bra_chatbot:app"]
```

### Cloud Deployment
- **Heroku**: Add `Procfile` with `web: gunicorn bra_chatbot:app`
- **AWS/Google Cloud**: Use the Docker image
- **DigitalOcean**: Deploy directly with their App Platform

## 🔍 Troubleshooting

### Common Issues

**Port Already in Use**
```bash
# Kill process using port 5000
lsof -ti:5000 | xargs kill -9
```

**Module Not Found**
```bash
# Reinstall dependencies
pip install --upgrade -r requirements.txt
```

**Template Not Found**
- Ensure `templates/` directory exists
- Check file paths are correct

### Debug Mode
Enable debug mode for detailed error messages:
```python
app.run(debug=True)
```

## 📊 Performance Tips

1. **Caching**: Implement response caching for frequently asked questions
2. **Database**: Add database support for conversation history
3. **Rate Limiting**: Implement API rate limiting for production
4. **CDN**: Use CDN for static files in production
5. **Monitoring**: Add logging and monitoring for production use

## 🔒 Security Considerations

- Input validation and sanitization
- Rate limiting to prevent abuse
- CORS configuration for production
- Environment variables for sensitive data
- Regular security updates

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## 📞 Support & Contact

For technical support or questions about the BRA Chatbot:

- **BRA Contact**: 081-2452073
- **Email**: esupport@bra.gob.pk
- **Address**: Balochistan Revenue Authority, Kalat Mall, First Floor, Raisani Road, Quetta

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🙏 Acknowledgments

- Balochistan Revenue Authority for providing comprehensive FAQ information
- Flask community for the excellent web framework
- Font Awesome for the beautiful icons
- Google Fonts for the Inter font family

## 🔄 Version History

- **v1.0.0** - Initial release with complete BRA FAQ system
- **v1.1.0** - Added responsive design and mobile support
- **v1.2.0** - Enhanced UI/UX with animations and better styling

---

**Made with ❤️ for Balochistan Revenue Authority**

*Serving the people of Balochistan with modern, efficient, and accessible tax services.*
