#!/bin/bash

# BRA Chatbot VPS Deployment Script
# This script helps you deploy the BRA chatbot to your VPS server

echo "🚀 BRA Chatbot VPS Deployment Guide"
echo "=================================="
echo ""

echo "📋 Step 1: Prepare your local files"
echo "1. Create a deployment folder on your local machine"
echo "2. Copy all your BRA chatbot files to this folder"
echo "3. Make sure you have the following files:"
echo "   - bra_chatbot.py"
echo "   - requirements.txt"
echo "   - templates/index.html"
echo "   - static/css/style.css"
echo "   - static/js/script.js"
echo "   - static/assets/ (with your form files)"
echo ""

echo "📋 Step 2: Connect to your VPS server"
echo "1. Open terminal/command prompt"
echo "2. Connect using SSH:"
echo "   ssh username@your-server-ip"
echo "   (Replace 'username' with your VPS username and 'your-server-ip' with your server IP)"
echo ""

echo "📋 Step 3: Install Python and dependencies on VPS"
echo "1. Update system packages:"
echo "   sudo apt update && sudo apt upgrade -y"
echo ""
echo "2. Install Python 3 and pip:"
echo "   sudo apt install python3 python3-pip python3-venv -y"
echo ""
echo "3. Install Nginx (web server):"
echo "   sudo apt install nginx -y"
echo ""
echo "4. Install Gunicorn (WSGI server):"
echo "   sudo apt install gunicorn -y"
echo ""

echo "📋 Step 4: Upload your files to VPS"
echo "1. Create a directory for your chatbot:"
echo "   mkdir -p /home/username/bra_chatbot"
echo "   cd /home/username/bra_chatbot"
echo ""
echo "2. Upload your files using SCP (from your local machine):"
echo "   scp -r /path/to/your/bra_chatbot/* username@your-server-ip:/home/username/bra_chatbot/"
echo ""
echo "   OR use SFTP:"
echo "   sftp username@your-server-ip"
echo "   put -r /path/to/your/bra_chatbot/* /home/username/bra_chatbot/"
echo ""

echo "📋 Step 5: Set up Python virtual environment on VPS"
echo "1. Navigate to your chatbot directory:"
echo "   cd /home/username/bra_chatbot"
echo ""
echo "2. Create virtual environment:"
echo "   python3 -m venv bra_chatbot_env"
echo ""
echo "3. Activate virtual environment:"
echo "   source bra_chatbot_env/bin/activate"
echo ""
echo "4. Install Python dependencies:"
echo "   pip install -r requirements.txt"
echo ""

echo "📋 Step 6: Configure Nginx"
echo "1. Create Nginx configuration file:"
echo "   sudo nano /etc/nginx/sites-available/bra_chatbot"
echo ""
echo "2. Add the following configuration:"
echo "   server {"
echo "       listen 80;"
echo "       server_name your-domain.com www.your-domain.com;"
echo ""
echo "       location / {"
echo "           proxy_pass http://127.0.0.1:5000;"
echo "           proxy_set_header Host \$host;"
echo "           proxy_set_header X-Real-IP \$remote_addr;"
echo "           proxy_set_header X-Forwarded-For \$proxy_add_x_forwarded_for;"
echo "           proxy_set_header X-Forwarded-Proto \$scheme;"
echo "       }"
echo "   }"
echo ""
echo "3. Enable the site:"
echo "   sudo ln -s /etc/nginx/sites-available/bra_chatbot /etc/nginx/sites-enabled/"
echo ""
echo "4. Test Nginx configuration:"
echo "   sudo nginx -t"
echo ""
echo "5. Restart Nginx:"
echo "   sudo systemctl restart nginx"
echo ""

echo "📋 Step 7: Create systemd service for your chatbot"
echo "1. Create service file:"
echo "   sudo nano /etc/systemd/system/bra_chatbot.service"
echo ""
echo "2. Add the following content:"
echo "   [Unit]"
echo "   Description=BRA Chatbot"
echo "   After=network.target"
echo ""
echo "   [Service]"
echo "   User=username"
echo "   WorkingDirectory=/home/username/bra_chatbot"
echo "   Environment=PATH=/home/username/bra_chatbot/bra_chatbot_env/bin"
echo "   ExecStart=/home/username/bra_chatbot/bra_chatbot_env/bin/gunicorn --bind 127.0.0.1:5000 bra_chatbot:app"
echo "   Restart=always"
echo ""
echo "   [Install]"
echo "   WantedBy=multi-user.target"
echo ""
echo "3. Enable and start the service:"
echo "   sudo systemctl daemon-reload"
echo "   sudo systemctl enable bra_chatbot"
echo "   sudo systemctl start bra_chatbot"
echo ""

echo "📋 Step 8: Configure firewall (if needed)"
echo "1. Allow HTTP traffic:"
echo "   sudo ufw allow 80"
echo "   sudo ufw allow 443"
echo ""
echo "2. Enable firewall:"
echo "   sudo ufw enable"
echo ""

echo "📋 Step 9: Test your deployment"
echo "1. Check if your chatbot is running:"
echo "   sudo systemctl status bra_chatbot"
echo ""
echo "2. Check Nginx status:"
echo "   sudo systemctl status nginx"
echo ""
echo "3. Test your chatbot:"
echo "   Open your browser and go to: http://your-server-ip"
echo ""

echo "📋 Step 10: Optional - Set up SSL certificate (for HTTPS)"
echo "1. Install Certbot:"
echo "   sudo apt install certbot python3-certbot-nginx -y"
echo ""
echo "2. Get SSL certificate:"
echo "   sudo certbot --nginx -d your-domain.com -d www.your-domain.com"
echo ""

echo "🎉 Your BRA chatbot should now be live on your VPS!"
echo "Access it at: http://your-server-ip or https://your-domain.com"
echo ""
echo "📞 For support, check the logs:"
echo "   sudo journalctl -u bra_chatbot -f"
echo ""
