#!/usr/bin/env python3
"""
Python Practice File for Beginners
Welcome to Python! This file contains basic examples and exercises.
"""

# ===== BASIC PYTHON CONCEPTS =====

# 1. Print statements
print("Hello, World!")
print("Welcome to Python programming!")

# 2. Variables and data types
name = "Sadaqath"
age = 25
height = 5.9
is_student = True

print(f"Name: {name}")
print(f"Age: {age}")
print(f"Height: {height} feet")
print(f"Is student: {is_student}")

# 3. Basic arithmetic operations
a = 10
b = 5

addition = a + b
subtraction = a - b
multiplication = a * b
division = a / b
power = a ** b

print(f"\nBasic Math with {a} and {b}:")
print(f"Addition: {addition}")
print(f"Subtraction: {subtraction}")
print(f"Multiplication: {multiplication}")
print(f"Division: {division}")
print(f"Power: {power}")

# 4. Lists (arrays)
fruits = ["apple", "banana", "orange", "grape"]
numbers = [1, 2, 3, 4, 5]

print(f"\nFruits list: {fruits}")
print(f"First fruit: {fruits[0]}")
print(f"Last fruit: {fruits[-1]}")

# Adding to list
fruits.append("mango")
print(f"After adding mango: {fruits}")

# 5. Loops
print("\nCounting from 1 to 5:")
for i in range(1, 6):
    print(f"Count: {i}")

print("\nLooping through fruits:")
for fruit in fruits:
    print(f"I like {fruit}")

# 6. Conditional statements
temperature = 25

if temperature > 30:
    print("It's hot outside!")
elif temperature > 20:
    print("Nice weather!")
else:
    print("It's cold outside!")

# 7. Functions
def greet_user(username):
    """Function to greet a user"""
    return f"Hello, {username}! Nice to meet you."

def calculate_area(length, width):
    """Function to calculate rectangle area"""
    return length * width

# Using functions
greeting = greet_user("Python Learner")
print(f"\n{greeting}")

area = calculate_area(10, 5)
print(f"Rectangle area (10 x 5): {area}")

# 8. Dictionary (key-value pairs)
student_info = {
    "name": "John",
    "age": 20,
    "grade": "A",
    "subjects": ["Math", "Science", "English"]
}

print(f"\nStudent Info:")
print(f"Name: {student_info['name']}")
print(f"Age: {student_info['age']}")
print(f"Grade: {student_info['grade']}")
print(f"Subjects: {student_info['subjects']}")

# ===== PRACTICE EXERCISES =====
print("\n" + "="*50)
print("PRACTICE EXERCISES - Try to solve these!")
print("="*50)

# Exercise 1: Create a function that adds two numbers
def add_numbers(x, y):
    # TODO: Write code to add x and y
    pass  # Remove this line and write your code

# Exercise 2: Create a list of your favorite movies
favorite_movies = []  # Add your favorite movies here

# Exercise 3: Write a function to check if a number is even or odd
def is_even(number):
    # TODO: Return True if even, False if odd
    pass  # Remove this line and write your code

# Exercise 4: Create a simple calculator
def simple_calculator(num1, num2, operation):
    """
    Simple calculator function
    operation can be: 'add', 'subtract', 'multiply', 'divide'
    """
    # TODO: Implement the calculator logic
    pass  # Remove this line and write your code

# Exercise 5: Count vowels in a word
def count_vowels(word):
    """Count the number of vowels in a given word"""
    # TODO: Count vowels (a, e, i, o, u) in the word
    pass  # Remove this line and write your code

# ===== TIPS FOR LEARNING PYTHON =====
print("\n" + "="*50)
print("PYTHON LEARNING TIPS:")
print("="*50)
print("1. Practice coding every day, even if it's just 15 minutes")
print("2. Start with small projects and gradually increase complexity")
print("3. Read error messages carefully - they help you learn!")
print("4. Use print() statements to debug your code")
print("5. Don't be afraid to experiment and break things")
print("6. Join Python communities and ask questions")
print("7. Build projects that interest you")
print("\nHappy coding! 🐍")

# To run this file, save it and run: python3 python_practice.py
